use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- 2420 DEV-91923
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[sp_GetAppendedInterviewers]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[sp_GetAppendedInterviewers]
'

declare @ProjectPayload02 nvarchar(max) = N'
-- This stored procedure requires #Interviewers table to be created by the caller
CREATE PROCEDURE [dbo].[sp_GetAppendedInterviewers]
    @projectId INT,
	@unknownAgent NVARCHAR(19)
AS
BEGIN
    SET NOCOUNT ON;

    INSERT INTO #Interviewers
    SELECT DISTINCT
        H.[HisInterviewer] AS [ID], 
        CASE
            WHEN H.[HisInterviewer] IN (N''***'', N''PD*'')
                THEN H.[HisInterviewer]
            WHEN LTRIM(RTRIM(ISNULL(rch.[Name], '''')))
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], '''')))
                + LTRIM(RTRIM(ISNULL(TA.[LastName],''''))) <> ''''
                THEN ''('' + LTRIM(RTRIM(ISNULL(rch.[Name], ''''))) + '') ''
                + LTRIM(RTRIM(ISNULL(TA.[FirstName], ''''))) + '' ''
                + LTRIM(RTRIM(ISNULL(TA.[LastName], ''''))) 
            WHEN I.[IntName] IS NOT NULL
                THEN I.[IntName]
                ELSE H.[HisInterviewer] + N'' '' + @unknownAgent
        END AS [Name], 
        0 AS [NodeNotEmpty],
		0 AS [Status],
		0 AS [ItemType],
		@projectId AS [ParentID]
    FROM (
	    SELECT DISTINCT [HisInterviewer]
	    FROM [dbo].[Historic] WITH(NOLOCK)
	    WHERE [HisInterviewer] <> N''***''
	) H 
    LEFT JOIN [dbo].[tblObjects] rch WITH(NOLOCK) ON rch.[k_Id] = CASE WHEN ISNUMERIC(H.[HisInterviewer]) <> 0
        THEN H.[HisInterviewer]
        ELSE -1
        END
    LEFT JOIN [dbo].[tblAgents] TA WITH(NOLOCK) ON TA.[k_id] = CASE WHEN ISNUMERIC(H.[HisInterviewer]) <> 0
        THEN H.[HisInterviewer]
        ELSE -1
        END 
    LEFT JOIN [dbo].[Interviewer] I WITH(NOLOCK) ON I.[IntInitiale] = H.[HisInterviewer] 
    WHERE NOT EXISTS (
	    SELECT 1
		FROM #Interviewers i WITH(NOLOCK)
		WHERE i.[ID] = H.[HisInterviewer]
	);
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

        print 'Project Payload 2'
        if isnull(@ProjectPayload02, '') <> '' exec @DBSQL @ProjectPayload02

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

